unit MainDM;

interface

uses
  {$IFDEF Linux}QForms, {$ELSE}Forms, {$ENDIF}
  SysUtils, Classes, DBXpress, DB, SqlExpr, FMTBcd, Provider, DBClient,
  SimpleDS, IWCompButton;

type
  TDMMain = class(TDataModule)
    SQLConnection: TSQLConnection;
    dspAluno: TDataSetProvider;
    dspProfessor: TDataSetProvider;
    dspCurso: TDataSetProvider;
    cdsProfessor: TClientDataSet;
    cdsCurso: TClientDataSet;
    cdsProfessorPROFESSOR_ID: TIntegerField;
    cdsProfessorNOME: TStringField;
    cdsProfessorENDERECO: TStringField;
    cdsProfessorBAIRRO: TStringField;
    cdsProfessorCIDADE: TStringField;
    cdsProfessorESTADO: TStringField;
    cdsProfessorDATA_NASCIMENTO: TDateField;
    cdsProfessorTELEFONE: TStringField;
    cdsProfessorEMAIL: TStringField;
    cdsProfessorCELULAR: TStringField;
    cdsProfessorDDD: TStringField;
    dsProfessor: TDataSource;
    dsCurso: TDataSource;
    cdsCursoCURSO_ID: TIntegerField;
    cdsCursoPROFESSOR_ID: TIntegerField;
    cdsCursoNOME: TStringField;
    cdsCursoDURACAO: TSmallintField;
    sqldstFormaPagto: TSQLDataSet;
    dspFormaPagto: TDataSetProvider;
    cdsFormaPagto: TClientDataSet;
    dsFormaPagto: TDataSource;
    sqldstFormaPagtoFORMA_PAGAMENTO_ID: TIntegerField;
    sqldstFormaPagtoNOME: TStringField;
    cdsFormaPagtoFORMA_PAGAMENTO_ID: TIntegerField;
    cdsFormaPagtoNOME: TStringField;
    cdsAluno: TClientDataSet;
    cdsAlunoALUNO_ID: TIntegerField;
    cdsAlunoNOME: TStringField;
    cdsAlunoENDERECO: TStringField;
    cdsAlunoBAIRRO: TStringField;
    cdsAlunoCIDADE: TStringField;
    cdsAlunoESTADO: TStringField;
    cdsAlunoCURSO_ID: TIntegerField;
    cdsAlunoFORMA_PAGAMENTO_ID: TIntegerField;
    cdsAlunoDATA_NASCIMENTO: TDateField;
    cdsAlunoTELEFONE: TStringField;
    cdsAlunoEMAIL: TStringField;
    cdsAlunoCELULAR: TStringField;
    cdsAlunoDDD: TStringField;
    dsAluno: TDataSource;
    sqldstAluno: TSQLDataSet;
    sqldstProfessor: TSQLDataSet;
    sqldstCurso: TSQLDataSet;
    sqldstAlunoALUNO_ID: TIntegerField;
    sqldstAlunoCURSO_ID: TIntegerField;
    sqldstAlunoFORMA_PAGAMENTO_ID: TIntegerField;
    sqldstAlunoNOME: TStringField;
    sqldstAlunoENDERECO: TStringField;
    sqldstAlunoBAIRRO: TStringField;
    sqldstAlunoCIDADE: TStringField;
    sqldstAlunoESTADO: TStringField;
    sqldstAlunoDATA_NASCIMENTO: TDateField;
    sqldstAlunoTELEFONE: TStringField;
    sqldstAlunoEMAIL: TStringField;
    sqldstAlunoCELULAR: TStringField;
    sqldstAlunoDDD: TStringField;
    sqldstProfessorPROFESSOR_ID: TIntegerField;
    sqldstProfessorNOME: TStringField;
    sqldstProfessorENDERECO: TStringField;
    sqldstProfessorBAIRRO: TStringField;
    sqldstProfessorCIDADE: TStringField;
    sqldstProfessorESTADO: TStringField;
    sqldstProfessorDATA_NASCIMENTO: TDateField;
    sqldstProfessorTELEFONE: TStringField;
    sqldstProfessorEMAIL: TStringField;
    sqldstProfessorCELULAR: TStringField;
    sqldstProfessorDDD: TStringField;
    sqldstCursoCURSO_ID: TIntegerField;
    sqldstCursoPROFESSOR_ID: TIntegerField;
    sqldstCursoNOME: TStringField;
    sqldstCursoDURACAO: TSmallintField;
    procedure cdsProfessorAfterPost(DataSet: TDataSet);
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure dsProfessorStateChange(Sender: TObject);
  private
    FIWButtons: TList;
    function GetIWButtons(Index: Integer): TIWButton;
    procedure SetIWButton(Index: Integer; const Value: TIWButton);
    procedure EnableButtons(const AEnabled: Boolean);
  public
    property IWButtons[Index: Integer]: TIWButton read GetIWButtons write SetIWButton;
  end;

function DMMain: TDMMain;

implementation

uses
  IWInit, UserSession;

{$R *.dfm}

function DMMain: TDMMain;
begin
  Result := TIWUserSession(WebApplication.Data).DMMain;
end;

procedure TDMMain.cdsProfessorAfterPost(DataSet: TDataSet);
begin
  // TypeCast para a Classe TCustomClientDataSet, sendo assim
  // podemos tanto trabalhar com um SimpleDataSet quanto com
  // um TClientDataSet.
  (DataSet as TCustomClientDataSet).ApplyUpdates(0);
end;

procedure TDMMain.EnableButtons(const AEnabled: Boolean);
begin
  TIWButton(FIWButtons[0]).Enabled := AEnabled;
  TIWButton(FIWButtons[1]).Enabled := AEnabled;
  TIWButton(FIWButtons[2]).Enabled := AEnabled;
  TIWButton(FIWButtons[3]).Enabled := not AEnabled;
  TIWButton(FIWButtons[4]).Enabled := not AEnabled;
end;

// Obtem um Boto da Lista de IWButtons, caso a lista esteja
// vazia o mtodo levantar uma exceo que ser enviada para
// o cliente(Browser) num formato de Mensagem 'Warning'.
function TDMMain.GetIWButtons(Index: Integer): TIWButton;
begin
  if FIWButtons.Count = 0 then
    raise Exception.Create('No h botes na lista')
  else
    Result := TIWButton(FIWButtons[Index]);
end;

// Adiciona o(s) Boto(es) na lista, apenas adiciona se o Indice da Propriedade
// for Maior que a quantidade de Botes, ou seja, caso seja repedito o Indice da
// Propriedade, no momento da atribuio dos Botes, esse ndice repetido no ser
// levado em considerao, pulando para o prximo boto a ser inserido na lista.
procedure TDMMain.SetIWButton(Index: Integer; const Value: TIWButton);
begin
  if (Index > FIWButtons.Count) then
    FIWButtons.Add(Value)
end;

// Inicializa a Lista de Botes.
procedure TDMMain.DataModuleCreate(Sender: TObject);
begin
  FIWButtons := TList.Create;
end;

// LIbera a lista de Botes.
procedure TDMMain.DataModuleDestroy(Sender: TObject);
begin
  FIWButtons.Free;
end;

// muda o estado dos botes de acordo com o estado do
// DataSet Vinculado ao DataSource.
procedure TDMMain.dsProfessorStateChange(Sender: TObject);
begin
  EnableButtons(not ((Sender as TDataSource).DataSet.State in [dsInsert, dsEdit]));
end;

end.
